CREATE OR REPLACE FUNCTION TSystem.views__ReportingBelkopf__recreate() RETURNS VOID AS $$
BEGIN


    DROP VIEW IF EXISTS treporting.rechnung_pos_beleg_positionen;
    CREATE OR REPLACE VIEW treporting.rechnung_pos_beleg_positionen AS
     SELECT
      'belzeil'::VARCHAR(30)                                        AS position_tablename,
      belzeil_grund.dbrid                                           AS position_dbrid,
      bz_id                                                         AS position_id,
      CAST(bz_be_bnr||'-'||bz_pos AS VARCHAR(30))                   AS position_abzu_join_id,
      be_prof                                                       AS position_status, --zum identifizieren von Rechnung und Gutschrift für evtl Darstellungsunterschiede auf Dokument (Zahlungsart)
      bz_lfs                                                        AS position_identnummer,  --rechnung : erste referenz ist Lieferschein
      bz_pos                                                        AS position_identpos,
      
      belzeil_grund.insert_date                                     AS datum_erfasst,
      
      (TBeleg.GetDokumentNrAndDatumFromPos(bz_belp_id)).erstelldatum  AS referenz_identdatum,  --lieferschein vomDatum
      COALESCE(bz_hwpos, bz_pos::VARCHAR(5))                        AS position_coalesce_handwerker_posnr,

      'E'::CHAR(1)                                                  AS position_status1,      --rechnung : 2. referenz ist auftrag, aus dem der lieferschein war
      IFTHEN(be_prof='G', bz_bz_be_bnr, bz_auftg)                   AS position_identnummer1,
      IFTHEN(be_prof='G', bz_bz_pos::VARCHAR(5), IFTHEN(bz_hwpos IS NULL, bz_auftgpos::VARCHAR(5), ag_hwpos)) --IFTHEN(bz_hwpos IS NULL, bz_auftgpos, NULL) eingebaut durch DS 2017-10-30: Sobald es eine HWPOS gab, hat es immer die Referenznummer in klein angezeigt. Überlegung: Strukturpos 
                                                                    AS position_identpos1, --7891 Rechnungs-Positionsnummer auf der Gutschrift anzeigen PHKO 

      bz_be_bnr                                                     AS position_dokument_id,
      false                                                         AS position_israhmenabruf,
      NULL::CHAR(1)                                                 AS position_rahmen_nr_referenz,
      NULL::INTEGER                                                 AS position_rahmen_abrufnr,

      bz_bda                                                        AS referenz,
      ag_bdapos                                                     AS referenz_pos, --achtung, gibt kein bz_bdapos
      IFTHEN(be_prof='G', NULL, ag_bdat)                            AS referenz_vondatum,           --Keine Auftragsreferenz in der Gutschrift
      NULL::FLOAT                                                   AS referenz_menge,              --Lieferschein: Menge Bestellt (Verkauf an Kunde)
      NULL::FLOAT                                                   AS referenz_menge_erledigt,     --Lieferschein: Menge bereits geliefert 

      ag_dispokrzl                                                  AS adresse_ansprechpartner_adressant_kurzzeichen,
      ag_dispo                                                      AS adresse_ansprechpartner_adressant,
      NULL::CHAR(1)                                                 AS adresse_ansprechpartner_intern_ident,
      NULL::CHAR(1)                                                 AS adresse_ansprechpartner_intern_name,

      be_rkrz                                                       AS adresse_adressant,
      be_liefkrz                                                    AS adresse_lieferadresse,
      NULL::CHAR(1)                                                 AS adresse_rechnungsadresse,

      bz_aknr                                                       AS artikelnummer,
      ag_aknr_idx                                                   AS artikelnummer_index,
      ag_aknr_referenz                                              AS artikelnummer_adressant,

      COALESCE(ag_aknr_referenz, bz_aknr)                           AS artikelnummer_coalesce_adressant_intern,
      COALESCE(bz_akbz, lang_artbez(bz_aknr, ReportLang_current()), ak_bez)
                                                                    AS artikelbezeichnung, 
      COALESCE(bz_akbz, az_bez, lang_artbez(bz_aknr, ReportLang_current()), ak_bez)
                                                                    AS artikelbezeichnung_coalesce_adressant_intern,
      ak_znr                                                        AS artikel_zeichnungsnummer,
      COALESCE(lang_artdim(bz_aknr, ReportLang_current()), ak_dim)  AS artikel_dimension,
      COALESCE(lang_artmat(bz_aknr, ReportLang_current()), ak_mat)  AS artikel_materialnummer,
      ak_din                                                        AS artikel_materialnorm,
      bz_fakt_uf1*ak_gewicht                                        AS artikel_pos_gewicht,
      NULL::INTEGER                                                 AS artikel_kost_rust,
      NULL::INTEGER                                                 AS artikel_kost_fert,
      NULL::INTEGER                                                 AS artikel_kost_mat,
      NULL::INTEGER                                                 AS artikel_kost_aw,
      ak_warencode                                                  AS artikel_warencode,
      ak_fertigung                                                  AS artikel_fert,
      (SELECT lang_land( ak_l_iso, ReportLang_current() ))          AS artikel_ursprung,  

      false                                                         AS done, --Zahlung?
      false                                                         AS storno,
      False                                                         AS optional,

      be_umr                                                        AS kurs_waer,
      bz_preis                                                      AS preis_me_netto, --war bz_vkp
      bz_preiseinheit                                               AS preiseinheit, -- 6447, 6772
      bz_vkp_uf1                                                    AS preis_me_netto_uf1, -- 7678 , war NULL::FLOAT 
      bz_vkp_basis_w                                                AS preis_me_netto_basis_w,
      NULL::FLOAT                                                   AS preis_me_netto_basis_w_uf1,   
      COALESCE(bz_vkp_mce, bz_mce)                                  AS preis_mengeneinheit_artmgc_id, -- 7678
      lang_artmgc_id_iso(COALESCE(bz_vkp_mce, bz_mce), ReportLang_current())  AS preis_mengeneinheit_bez_iso, -- 7678
      bz_tot                                                        AS preis_inkl_rabatt_abzu,
      bz_tot_steu                                                   AS preis_inkl_rabatt_abzu_steuer,
      (bz_preis*IFTHEN(bz_canrabatt, (1-bz_arab/100), 1))           AS preis_me_inkl_posrabatt_ohne_abzu, --war bz_vkp
      (bz_preis*IFTHEN(bz_canrabatt, (1-bz_arab/100)*(1-bz_gesrab/100), 1))
                                                                    AS preis_me_inkl_rabatt_ohne_abzu,
      NULL::FLOAT                                                   AS preis_positionswert_nur_hauptpos_werthaltig,
      NULL::FLOAT                                                   AS preis_pos_abzusum,

      bz_vkptotalpos OR belzeil_get_auftgmainpos(bz_id, true) IS NULL AS poshatvkp,

      bz_steuproz                                                   AS steuproz,

      bz_fakt                                                       AS menge,
      ((tartikel.me__menge_uf1__in__menge(COALESCE(bz_vkp_mce, bz_mce), bz_fakt_uf1))/Do1If0(bz_fakt))::NUMERIC(12,4)
                                                                    AS menge_1in_preiseinheit,  -- 7678 Umrechnungsfaktor: 1 Einheit der Menge entspricht 1 Einheit der Menge des Preises
      NULL::FLOAT                                                   AS menge_rahmen_abrlos,
      bz_fakt_uf1                                                   AS menge_uf1,
      NULL::FLOAT                                                   AS menge_geliefert_uf1, 
      NULL::FLOAT                                                   AS menge_verrechnet,    --Anzahlungsmenge in richtiger Rechnung?
      --belp_menge-belp_menge_done                                  AS menge_offen_mengeneinheit,
      NULL::FLOAT                                                   AS menge_offen_uf1,
      bz_arab                                                       AS rabatt,
      bz_rabhint                                                    AS rabatt_hint,
      bz_gesrab                                                     AS rabatt_ges,  
      bz_mce                                                        AS mengeneinheit_artmgc_id,
      COALESCE(lang_artmgc_id_iso(bz_mce, ReportLang_current()), bz_mcbez)
                                                                    AS mengeneinheit_bez_iso,

      COALESCE(IFTHEN(Trim(bz_zubez_rtf)='', NULL::TEXT, bz_zubez_rtf), bz_zubez)::TEXT AS postxt_rtf,

      bz_an_nr                                                      AS an_nr,
      (SELECT an_bez FROM anl WHERE an_nr=bz_an_nr)                 AS an_bez,

      NULL::DATE/*belp_termin*/                                     AS datum_geplant,
      NULL::DATE/*belp_termin_bestaetigt*/                          AS datum_bestaetigt,
      NULL::DATE                                                    AS datum_coalesce_bestaetigt_geplant,
      NULL::CHAR(1)                                                 AS datum_text,
      NULL::DATE                                                    AS datum_woche_geplant,
      NULL::DATE                                                    AS datum_woche_bestaetigt,
      NULL::CHAR(1)                                                 AS datum_woche,
      NULL::DATE                                                    AS datum_auslieferung

    FROM
      belzeil_grund JOIN belkopf ON be_bnr=bz_be_bnr --wegen Adressdaten
                    LEFT JOIN art ON ak_nr=bz_aknr
                    LEFT JOIN auftg ON ag_astat='E' AND ag_nr=bz_auftg AND ag_pos=bz_auftgpos  --durch "E" geht keine Proformarechnung auf Angebot. Naja .... 2017-10-30 DS
                    LEFT JOIN adressen_view ON ad_krz=be_rkrz 
                    LEFT JOIN artzuo ON az_id=(SELECT az_id FROM artzuo WHERE az_prokrz=adk_ad_krz AND az_pronr=bz_aknr ORDER BY az_gdatum DESC LIMIT 1)
    ORDER BY
      bz_pos;  

    DROP VIEW IF EXISTS treporting.rechnung_beleg_kopfdaten;
    CREATE OR REPLACE VIEW treporting.rechnung_beleg_kopfdaten AS
     SELECT
       be_bnr                                                       AS dokument_id,
       be_bnr                                                       AS dokument_join_id,
       be_bnr                                                       AS dokument_dms_id, 
       be_bnr                                                       AS dokument_nummer,
       be_abprozent                                                 AS dokument_anzahlprozent,
       be_prof                                                      AS dokument_status,

       --(SELECT count(1) FROM (SELECT bz_lfs FROM belzeil_grund WHERE bz_be_bnr=be_bnr GROUP BY bz_lfs) AS a)>1
       -- OR --auskommentiert DS 2017-10-30 : was soll der blödsinn? weiterhin DISTINCT eingefügt vor bz_lfs
       (SELECT count(1) FROM (SELECT DISTINCT bz_lfs FROM belzeil_grund WHERE bz_be_bnr=be_bnr GROUP BY bz_lfs) AS a)>1   
                                                                    AS dokument_multidok,   
       be_def                                                       AS definitiv,
       
       'rechnung'::VARCHAR(10)                                      AS doktype_force,
       
       be_bdat                                                      AS dokument_erstelldatum,
       
       COALESCE(be_valuta,be_bdat)+be_zak                           AS dokument_faelligdatum,

       'trans.kopf.ihrebestellung'::VARCHAR(75)                     AS dokument_reftitkunde,
       'trans.kopf.unserlief'::VARCHAR(75)                          AS dokument_reftiteigen,
       IFTHEN(be_prof='G','trans.kopf.bezugsrechnung'::VARCHAR(75), 'trans.kopf.unserauftrag'::VARCHAR(75))
                                                                    AS dokument_reftiteigen1, 

       COALESCE(be_titel, lang_belart(be_txba, ReportLang_current()))
                                                                    AS dokument_titel,
       lang_belart(be_txba, ReportLang_current())                   AS dokument_titel_doktype,                                                            
       COALESCE(be_bem1_rtf, be_bem1)                               AS dokument_kopftext,
       COALESCE(be_bem2_rtf, be_bem2)                               AS dokument_fusstext,
       NULL::TEXT                                                   AS dokument_qhint,
       
       --IFTHEN(a1_export, belarzu__zu_tit__gettxt('EXPORT-INT'), IFTHEN(a1_euexport, belarzu__zu_tit__gettxt('EXPORT-EU'), NULL::VARCHAR))
       COALESCE(be_txtexp_rtf, be_txtexp)                           AS dokument_exporttxt,
       --IFTHEN(a1_ursprungstxt, belarzu__zu_tit__gettxt('EXPORT-URSPRUNG'), NULL::VARCHAR)
       COALESCE(be_txtexpurspr_rtf, be_txtexpurspr)                 AS dokument_exportursprungtxt,
       
       belarzu__zu_tit__gettxt('DOKU_EMAILTXT', ReportLang_current(), false)
                                                                    AS dokument_emailtxt,                                                             
       CASE WHEN be_prof='G' THEN
            ((SELECT count(1) FROM (SELECT DISTINCT COALESCE(bz_bz_be_bnr,''), COALESCE(bz_lfs,'') FROM belzeil_grund WHERE bz_be_bnr=be_bnr) AS x)) -- Gutschrift: Gruppierung nach Original-Rechnung und Lieferschein
            ELSE -- Sonstige Rechnungsarten
                ((SELECT count(1) FROM (SELECT DISTINCT COALESCE(bz_auftg,''), COALESCE(bz_bda,''), COALESCE(bz_an_nr,''), COALESCE(TBeleg.GetDokumentNrFromPos(bz_belp_id),'') FROM belzeil_grund WHERE bz_be_bnr=be_bnr) AS a))
       END 
                                                                    AS dokument_positiongroupcount, --eine gleiche referenz über alles?                                                             

       be_apkrzl                                                    AS dokument_adresse_ansprechpartner_adressant_ident,
       be_ap                                                        AS dokument_adresse_ansprechpartner_adressant,
       ap_anr                                                       AS dokument_adresse_ansprechpartner_adressant_anr,
       ap_sex_man::VARCHAR(1)                                       AS dokument_adresse_ansprechpartner_adressant_man,
       ap_name                                                      AS dokument_adresse_ansprechpartner_adressant_nachname,
       ap_vorn                                                      AS dokument_adresse_ansprechpartner_adressant_vorname,
       ap_sysfun                                                    AS dokument_adresse_ansprechpartner_adressant_sysfun,
       ap_titel                                                     AS dokument_adresse_ansprechpartner_adressant_titel,

       be_rkrz                                                      AS dokument_adresse_adressant,
       adk_ad_krz                                                   AS dokument_adresse_ident, --zB dbrid für Parameter 

       ad_ustidnr                                                   AS ustidnr,

       be_gesamt_net                                                AS dokument_summe_netto,
       be_gesamt_steu                                               AS dokument_summe_brutto,

       NULL::FLOAT                                                  AS dokument_fixwert,
       --MF 15052018 NULL::FLOAT                                                  AS dokument_gesamtrabatt, --gesamtrabatt in rechnung muß bei position ausgewiesen werden, da mehrere aufträge kombiniert sein könnten
       CASE WHEN (SELECT count(1) FROM (SELECT DISTINCT bz_gesrab FROM belzeil_grund WHERE bz_be_bnr=be_bnr AND bz_tot>0 AND bz_gesrab>0) as bezgesrab )=1 THEN
    		(SELECT bz_gesrab FROM belzeil_grund WHERE bz_be_bnr=be_bnr AND bz_gesrab>0 LIMIT 1) -- #8884 Wenn es über die gesamte Rechnung nur einen Rabatt gibt, dann kann dieser als Gesamtrabatt ausgewiesen werden
    	WHEN (SELECT count(1) FROM (SELECT DISTINCT bz_gesrab FROM belzeil_grund WHERE bz_be_bnr=be_bnr AND bz_tot>0 AND bz_gesrab>0) as bezgesrab )>1 THEN
    		-1 --unterschiedliche Gesamtrabatte auf dem Dokument
    	ELSE 
    		NULL::FLOAT
       END                                                          AS dokument_gesamtrabatt,
       
      (SELECT SUM((bz_preis*bz_fakt*(1-bz_arab/100))-(bz_preis*bz_fakt*(1-bz_arab/100)*(1-bz_gesrab/100))) FROM belzeil_grund WHERE bz_be_bnr=be_bnr AND bz_gesrab>0 AND bz_canrabatt)
                                                                    AS dokument_gesamtrabatt_wert,     

       NULL::CHAR(1)                                                AS dokument_bindefrist,

       be_apint                                                     AS dokument_adresse_ap_intern_ident,
       nameAufloesen(be_apint)                                      AS dokument_adresse_ap_intern_name,
       NULL::CHAR(1)                                                AS dokument_adresse_ap_intern_ident2,
       NULL::CHAR(1)                                                AS dokument_adresse_ap_intern_name2,

       COALESCE(ap_mail, ad_email1)                                 AS adresse_adressant_email,

       a1_knr::VARCHAR(50)                                          AS dokument_adresse_knr_debi_or_kredi, 
       a1_eknr::VARCHAR(50)                                         AS dokument_adresse_adressant_knr_debi_or_kredi,
       COALESCE(be_waco, TSystem.Settings__Get('BASIS_W'))                     AS zahlung_waco,
       a1_spco                                                      AS sprache_debi_or_kredi, 
       a1_tolfrueh                                                  AS lieftolfrueh_debi_or_kredi,
       a1_tolspaet                                                  AS lieftolspaet_debi_or_kredi,
       a1_euexport                                                  AS euexport,
       a1_export                                                    AS intexport,
       IFTHEN(a1_euexport OR a1_export, a1_zaz, NULL::VARCHAR)      AS zazexport,   --ZAZ Nummer nur zeigen wenn Export
       IFTHEN(a1_euexport OR a1_export, ad_eori, NULL::VARCHAR)     AS eori_vertragspartner,    --EORI des Kunden
       
       be_zak                                                       AS zahlung_tage_zahlungbis,
       be_skv                                                       AS zahlung_tage_skontoverfall,
       be_sks                                                       AS zahlung_skontosatz_prozent,

       lang_za(a1_zahlart,ReportLang_current())                     AS zahlung_zahlart_name_debikredidat,
       be_kond                                                      AS zahlung_zahlkondition_bemerkung,
       
       kto_bknr,
       kto_blz,
       kto_bank,
       kto_bic,
       kto_iban,
       kto_pckonto,
       kto_bb,
          
       (SELECT s_bb FROM adkspco WHERE a1_spco = s_spco)            AS s_bb, --Hintergrund-Einstellung aus Sprache NEU

       NULL::INTEGER                                                AS versand_versandart_ident,
       COALESCE(lang_versart(v_id, ReportLang_current() ), be_vers)
                                                                    AS versand_versandart, -- neu #7137, war COALESCE(v_descr,be_vers)	
       CASE
        WHEN (SELECT COUNT(*) FROM (SELECT DISTINCT beld_versandort FROM lieferschein_pos JOIN lieferschein ON beld_id = belp_dokument_id WHERE belp_id IN ((SELECT DISTINCT bz_belp_id FROM belzeil_grund WHERE bz_be_bnr = be_bnr AND bz_belp_id IS NOT NULL ))) AS sub) = 1 THEN 
           (SELECT DISTINCT beld_versandort FROM lieferschein_pos JOIN lieferschein ON beld_id = belp_dokument_id WHERE belp_id IN ((SELECT DISTINCT bz_belp_id FROM belzeil_grund WHERE bz_be_bnr = be_bnr AND bz_belp_id IS NOT NULL )))
        WHEN (SELECT COUNT(*) FROM (SELECT DISTINCT atd_versandort FROM auftgdokutxt WHERE atd_dokunr IN ((SELECT COALESCE(ag_dokunr, 0) FROM auftg WHERE ag_nr IN ((SELECT bz_auftg FROM belzeil_grund WHERE bz_be_bnr = be_bnr AND bz_auftg IS NOT NULL ))))) AS sub) = 1 THEN 
           (SELECT DISTINCT atd_versandort FROM auftgdokutxt WHERE atd_dokunr IN ((SELECT COALESCE(ag_dokunr, 0) FROM auftg WHERE ag_nr IN ((SELECT bz_auftg FROM belzeil_grund WHERE bz_be_bnr = be_bnr AND bz_auftg IS NOT NULL )))))
        ELSE NULL
       END::VARCHAR AS versand_versandort,      -- Ort des Gefahrenübergangs, letzte Änderung durch #9466
       NULL::CHAR(1)                                                AS versand_bem,
       (SELECT (TAdk.DokVersandTyp(ad_dokversand)).ad_DokVersandBez FROM adk WHERE adk.ad_krz=adk_ad_krz) 
                                                                    AS dokument_versand, -- Dokumenten-Versandbezeichnung Adressstammdaten
       (SELECT MAX(bz_preiseinheit) FROM belzeil_grund WHERE bz_be_bnr=be_bnr) AS preiseinheit_max,
       (SELECT MAX(numeric_larger(LENGTH(ABS(bz_fakt-trunc(bz_fakt))::FLOAT::VARCHAR)-2,0)) FROM belzeil_grund WHERE bz_be_bnr=be_bnr)  --Float cast wirft nachfolgende 0en weg  http://postgresql.1045698.n5.nabble.com/strip-zeros-from-fractional-part-td1849963.html
                                                                    AS dokument_menge_numdigits,
       (SELECT COALESCE(MAX(LENGTH(bz_hwpos)),3) FROM belzeil_grund WHERE bz_be_bnr=be_bnr) 
                                                                    AS hwpos_max, --Strukturposition min 3, wenn bz_hwpos=NULL
       1                                                            AS bdapos_max, --Länge der Positionsnummerkunde 12607
       ((SELECT MAX(numeric_larger(LENGTH(ABS(bz_preis-trunc(bz_preis))::FLOAT::VARCHAR)-2,0)) FROM belzeil_grund WHERE bz_be_bnr=be_bnr))
                                                                    AS dokument_vkp_numdigits, --bz_preis war bz_vkp
       (SELECT MAX(numeric_larger(LENGTH(( (bz_preis*IFTHEN(bz_canrabatt, (1-bz_arab/100), 1))-trunc( ABS(bz_preis*IFTHEN(bz_canrabatt, (1-bz_arab/100), 1)) ))::FLOAT::VARCHAR)-2,2)) FROM belzeil_grund WHERE bz_be_bnr=be_bnr)
                                                                    AS dokument_arab_numdigits --bz_preis war bz_vkp
     FROM
       belkopf                      LEFT JOIN adressen_view ON ad_krz=be_rkrz --wegen Debitorendaten
                                    LEFT JOIN adk1 ON a1_krz=adk_ad_krz --debitorendaten zur Adresse
                                    LEFT JOIN ktovz ON kto_name=be_ktv_name OR (be_ktv_name IS NULL AND kto_std)
                                    LEFT JOIN adkap ON adk_ad_krz=ap_ad_krz AND ap_krzl=be_apkrzl AND ap_krzl IS NOT NULL 
                                    LEFT JOIN versart ON v_art ILIKE be_vers; --LIKE-JOIN http://redmine.prodat-sql.de/issues/4981#note-6


    DROP VIEW IF EXISTS treporting.rechnung_pos_abzuschlaege_pos;
    CREATE OR REPLACE VIEW treporting.rechnung_pos_abzuschlaege_pos AS
     SELECT
      CAST(beaz_bebnr||'-'||beaz_belpos AS VARCHAR(30))             AS position_id,
      lang_abzu(beaz_abz_id, ReportLang_current())                  AS bezeichnung,
      beaz_type                                                     AS typ,--                   #7939 PHKO
      beaz_pos                                                      AS pos,--                   #7939 PHKO
      beaz_anz                                                      AS anzahl,
      beaz_abzubetrag                                               AS preis,
      beaz_anz*beaz_abzubetrag                                      AS preis_wert_netto,
      beaz_abzuproz                                                 AS prozent,
      beaz_steu                                                     AS steuercode,
      beaz_steuproz                                                 AS steuerprozent,
      beaz_visible                                                  AS sichtbar,
      COALESCE(beaz_zutxt_rtf, beaz_zutxt)                          AS bemerkung,--             #7939 PHKO #9255 GEO
      beaz_zutxt_int                                                AS bemerkung_intern,--      #7939 PHKO
      (SELECT MAX(numeric_larger(LENGTH((beaz_anz-trunc(beaz_anz))::FLOAT::VARCHAR)-2,0)) FROM belabzu WHERE beaz_bebnr=be_bnr)  --Float cast wirft nachfolgende 0en weg  http://postgresql.1045698.n5.nabble.com/strip-zeros-from-fractional-part-td1849963.html
                                                                    AS abzu_menge_numdigits,
      ((SELECT MAX(numeric_larger(LENGTH((beaz_abzubetrag-trunc(beaz_abzubetrag))::FLOAT::VARCHAR)-2,0)) FROM belabzu WHERE beaz_bebnr=be_bnr))
                                                                    AS abzu_preis_numdigits
     FROM
      belabzu
      JOIN belkopf ON be_bnr = beaz_bebnr
     ORDER BY pos,bezeichnung;


     DROP VIEW IF EXISTS treporting.rechnung_abzuschlaege_beleg;
     CREATE OR REPLACE VIEW treporting.rechnung_abzuschlaege_beleg AS
      SELECT
       beaz_bebnr                                                   AS dokument_id,
       lang_abzu(beaz_abz_id, ReportLang_current())                 AS bezeichnung,
       beaz_type                                                    AS typ,--                   #7939 PHKO
       beaz_pos                                                     AS pos,--                   #7939 PHKO
       beaz_anz                                                     AS anzahl,
       beaz_abzubetrag                                              AS preis,
       beaz_anz*beaz_abzubetrag                                     AS preis_wert_netto,
       beaz_abzuproz                                                AS prozent,
       beaz_steu                                                    AS steuercode,
       beaz_steuproz                                                AS steuerprozent,
       beaz_visible                                                 AS sichtbar,
       COALESCE(beaz_zutxt_rtf, beaz_zutxt)                         AS bemerkung,--             #7939 PHKO #9255 GEO
       beaz_zutxt_int                                               AS bemerkung_intern--       #7939 PHKO
      FROM
       belabzu
       JOIN belkopf ON be_bnr = beaz_bebnr
      WHERE
       beaz_belpos IS NULL
      ORDER BY pos,bezeichnung;
       
       
     DROP VIEW IF EXISTS treporting.rechnung_steuerartenbetrag;
     CREATE OR REPLACE VIEW treporting.rechnung_steuerartenbetrag AS
     SELECT
      dokument_id,
      steucode,
      steuproz,
      SUM(steubetrag) AS steubetrag,
      steubez
     FROM
             (SELECT
              bz_be_bnr                                                     AS dokument_id,
              bz_steucode                                                   AS steucode,
              bz_steuproz                                                   AS steuproz,
              ROUND( (ROUND(SUM(bz_tot*COALESCE(be_abprozent/100,1)), 2) * bz_steuproz/100), 2)             AS steubetrag,
              lang_steu(bz_steucode, ReportLang_current())                  AS steubez
             FROM
              belzeil_grund
              JOIN belkopf ON be_bnr = bz_be_bnr
             WHERE
                (NOT bz_vkptotalpos OR NOT EXISTS(SELECT true FROM belzeil_grund b1 --Preis enthält Unterposition nur dann = 0, wenn auch Unterposition, sonst einbeziehen
                                                        WHERE b1.bz_be_bnr=belzeil_grund.bz_be_bnr
                                                            AND b1.bz_auftg=belzeil_grund.bz_auftg AND b1.bz_auftghpos=belzeil_grund.bz_auftgpos)) 
             GROUP BY
              bz_be_bnr, bz_steucode, bz_steuproz, be_abprozent, 5
             UNION
             -- Belegzuschläge ohne Pos-Bezug
             SELECT
              beaz_bebnr                                                    AS dokument_id,
              beaz_steu                                                     AS steucode,
              beaz_steuproz                                                 AS steuproz,
              ROUND( (ROUND(SUM(beaz_tot*COALESCE(be_abprozent/100,1)), 2) * beaz_steuproz/100), 2) AS steubetrag,
              lang_steu(beaz_steu, ReportLang_current())  AS steubez
             FROM
              belabzu
              JOIN belkopf ON be_bnr = beaz_bebnr AND beaz_belpos IS NULL
             GROUP BY
              beaz_bebnr, beaz_steu, beaz_steuproz, be_abprozent, 5) AS summe
     GROUP BY
              dokument_id, steucode, steuproz, 5;
  
END $$ LANGUAGE plpgsql;

--SELECT TSystem.views__ReportingBelkopf__recreate();
